
function p = build_params_template(N_RA, N_INT)
%BUILD_PARAMS_TEMPLATE Create a parameter struct `p` for N1DE_refactored.
%   Fill in numeric values based on your legacy globals / paper appendix.

p.N_RA  = N_RA;
p.N_INT = N_INT;

% Reversal / capacitances (example placeholders!)
p.VL = -70; p.VK = -90; p.VH = -30; p.VNa = 50; p.VAM = 0;
p.C_RA = 75; p.C_INT = 75;

% Maximal conductances (set per your calibration)
p.gL = 2; p.gCa = 10; p.gKRA = 1700; p.gNaRA = 800; p.gSKRA = 1; p.gARA = 1;
p.gNaINT = 1200; p.gKINT = 1700; p.gHINT = 4; p.gNap = 1;

% Gates / Ca / kinetics
p.Ca_ex = 2; p.RTF = 25; % fill properly
p.thetam=-40; p.thetan=-55; p.thetas=-20; p.thetaa=-50; p.thetae=-45;
p.sigmam=7; p.sigman=10; p.sigmas=6; p.sigmaa=8; p.sigmae=8;
p.taunbar=10; p.taue=20; p.tauh=1; p.tauhpbar=1000;
p.ks=0.3; p.Tmax=1; p.VT=-20; p.Kps=5;

% Synapses
p.gAMrr=10; p.arAM=1.5; p.adAM=0.8;
p.arGA=1.0; p.adGA=0.6;

% Applied currents (optional)
p.Iapp_RA  = zeros(1,N_RA);
p.Iapp_INT = zeros(1,N_INT);
end
